package com.izenpe.zain.cliente.wss;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaWSS {
	// Nombre del fichero a utilizar para la Generacin de la firma WSS.
	private static final String fileName = "WS-Security.xml";

	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL:
			 */
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil de firma WSS en la peticin de
			// Generacin de firma.
			smartSignReq.setProfile(Constants.Profile.WSS);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartSignReq.setLanguage("es");

			// Certificado con el que realizar la firma.
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);

			/*
			 * True para obtener la firma en base64 (y evitar problemas con Axis
			 * al serializar y deserializar firmas XML).
			 */
			smartSignReq.setXmlReturnBase64(true);
			
			/*
			 * Algoritmo de hash a utilizar para la firma. En caso de omitir
			 * esta lnea de cdigo, la firma por defecto es 'sha1'.
			 * Posibilidades: 1. md5 2. sha1 3. sha256 4. sha384 5. sha512
			 */
			smartSignReq.setDigestAlgorithm("sha1");

			// Datos a firmar.
			smartSignReq.setInputXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));

			// Envo de la peticin.
			SmartSignResponse smartSignResp = smartSignReq.send();

			/*
			 * Se comprueba la validez de la respuesta y se escribe la respuesta
			 * de Generacin de firma WSS en un fichero en disco.
			 */
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				String wss = smartSignResp.getDocumentWithSignatureXmlBase64();
				byte[] data = Base64.decode(wss);
				String destFilename = "data/output/" + fileName.substring(0, fileName.lastIndexOf(".")) + "Signed.xml";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("La firma ha sido generado con xito");
			} else {
				System.out.println("Error en la Generacin de Firma:" + smartSignResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}